const path = require('path')
const WebpackK6DevtoolPlugin = require('@k6/webpack-devtool-plugin')
const ThemeColorReplacer = require('webpack-theme-color-replacer')
const forElementUI = require('webpack-theme-color-replacer/forElementUI')
const { themeColorsList, currentThemeColor } = require('@k6/header/src/config/theme.config').themeConfig
const { mainColor, assistantColors } = themeColorsList.find(theme => theme.mainColor === currentThemeColor)

module.exports = {
  lintOnSave: true,
  publicPath: '/',
  assetsDir: 'assets',
  devServer: {
    overlay: {
      warnings: false,
      errors: false
    },
    proxy: process.env.VUE_APP_DOMAIN
  },
  chainWebpack: config => {
    config.resolve.alias
      .set('@', path.resolve(__dirname, 'src'))
    config
      .plugin('WebpackK6DevtoolPlugin')
      .use(WebpackK6DevtoolPlugin)

     // 主题色切换配置
     config.plugin('ThemeColorReplacer').use(ThemeColorReplacer, [
      {
        fileName: 'style/theme-colors.[contenthash:8].css',
        matchColors: [
          ...forElementUI.getElementUISeries(mainColor), // element-ui主色系列
          ...assistantColors
        ],
        changeSelector: forElementUI.changeSelector,
        isJsUgly: process.env.NODE_ENV === 'production' ? true : undefined
      }
    ])
  },
  devServer: {
    overlay: {
      warnings: false,
      errors: false
    },
    proxy: process.env.VUE_APP_DOMAIN
  }
}
