import Vue from 'vue'
import VueRouter from 'vue-router'
import { defineComponent } from 'vue-demi'
Vue.use(VueRouter)

const blankRouter = defineComponent({
  render() {
    return <router-view />
  }
})

const originalPush = VueRouter.prototype.push

VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err)
}

const router = new VueRouter({
  mode: 'history',
  scrollBehavior(to, from, savedPosition) {
    if (savedPosition) return savedPosition
    return { x: 0, y: 0 }
  },
  routes: [
    {
      path: '/',
      redirect: '/home'
    },
    {
      path: '/k6-login/',
      name: 'loginLayout',
      component: blankRouter,
      redirect: '/k6-login/login',
      children: [
        {
          path: 'login',
          name: 'login',
          component: () => import('@/views/TemplateLogin.vue'),
        }
      ]
    },
    {
      path: '/home',
      name: 'home',
      component: () => import('@/views/TemplateApp.vue')
    }
  ]
})

export default router
