import { appInit } from "@/core/bootstrap";
import Vue from "vue";
import App from "./App.vue";
import router from "./router";
import ElementUI, { Message } from "element-ui";
import "./styles/index.scss";
import { getMenus } from "./core/store";
import K6Core from "@k6/core-pc";
import K6Header, { init } from "@k6/header";
import developEntry from "../../develop-pc/developEntry";

Vue.use(K6Core, {
  developEntry,
});
Vue.use(ElementUI);
Vue.use(K6Header, {
  workbench: false,
  workbenchHome: false,
  create: false,
  task: false,
  control: false,
  message: false,
  browser: false,
  fullscreen: false,
  task: false,
  question: false,
  onAppClick: (app) => {
    if (app.id !== "addaf6c03841476e86c5d731adb31ae1") {
      getMenus(app);
    } else {
      Message.error(app.name + "暂不支持");
    }
  },
  userOptions: [
    {
      name: "主题",
      command: "setting",
    },
  ],
});

const app = new Vue({
  router,
  render: (h) => h(App),
});

appInit()
  .then((k6App) => {
    init().then(() => {
      getMenus(k6App);
      app.$mount("#app");
    });
  })
  .catch((err) => {
    app.$mount("#app");
  });
