import { reactive } from "vue-demi";
import { getMenuByAppId, getTabsByMenuId } from "@/api/index";

const store = reactive({
  menus: [],
  app: {},
  activeMenu: {},
  activeMenuId: "",
  tabId: "",
  tabs:[],
  appInfo: {}, // 当前应用信息
});

const getMenus = (app) => {
  store.app = app;
  store.appInfo = app;
  localStorage.setItem("appId", app.id);
  getMenuByAppId(app.id).then((data) => {
    store.menus = data;
    findActiveMenu();
  });
};

const findActiveMenu = () => {
  for (let i = 0; i < store.menus.length; i++) {
    const menu = store.menus[i];
    if (menu.children.length > 0) {
      store.activeMenu = menu.children[0];
      store.activeMenuId = store.activeMenu.id;
      if (store.activeMenu.formType !== 2) {
        getTabId(store.activeMenuId);
      }
      return;
    }
  }
};

const getTabId = (id) => {
  getTabsByMenuId(id).then((data) => {
    store.tabs = data
    store.tabId = data[0] ? data[0].id : "";
  });
};

const setActiveMenu = (id) => {
  store.activeMenuId = id;
  getTabId(id);
  for (let i = 0; i < store.menus.length; i++) {
    const menu = store.menus[i];
    for (let j = 0; j < menu.children.length; j++) {
      const submenu = menu.children[j];
      if (submenu.id === id) {
        store.activeMenu = submenu;
        return;
      }
    }
  }
};

window.useAppStore = () => {
  return store;
};

window.useMenuStore = () => {
  return {
    isCollapse: false,
    menus: store.menus,
    fixedMenus: [],
    currentMenu: store.activeMenu,
  };
};

export { store as default, getMenus, setActiveMenu };
