import { getApps, getAppById } from '@/api/index'
function projectInit(params) {
  // 设置tenant_id
  if (process.env.VUE_APP_TENANT_ID) {
    localStorage.setItem('tenantId', process.env.VUE_APP_TENANT_ID)
  }
  // 设置接口令牌
  if (process.env.VUE_APP_TOKEN) {
    localStorage.setItem('token', process.env.VUE_APP_TOKEN)
  }

  // 初始化完毕，设置 flag
  sessionStorage.setItem('projectInitialized', true)
}

if (process.env.VUE_APP_TOKEN) {
  // 本地开发环境
  // 项目初始化时才使用环境变量设置应用 ID、token 等各种数据
  // 当数据失效时，使用页面中悬浮的 eruda 调试工具更换，不需要重启项目
  if (!sessionStorage.getItem('projectInitialized')) {
    projectInit()
  }
}

// 线上环境页面刷新清空缓存
if (!sessionStorage.getItem('projectInitialized')) {
  sessionStorage.clear()
}

export const appInit = () => {
  return new Promise((resolve, reject) => {
    const localAppId = localStorage.getItem('appId')
    if (localAppId) {
      getAppById(localAppId).then(appInfo => {
        if (appInfo) {
          resolve(appInfo)
        }else {
          reject()
        }
      }).catch(err => {
        reject()
      })
    } else {
      getApps().then(list => {
        if (list) {
          const app = list.find(item => item.id !== 'addaf6c03841476e86c5d731adb31ae1')
          localStorage.setItem('appId', app.id)
          resolve(app)
        }else {
          reject()
        }
      }).catch(err => {
        reject()
      })
    }
  })
}
