import { Loading } from 'element-ui'
import { debounce } from 'lodash-es'
export default {
  instance: null,
  debounced: null,
  /**
   *
   * @param {*} manual boolean 手动控制
   */
  show(manual) {
    this.instance = Loading.service({ fullscreen: true, lock: true, background: 'rgba(255, 255, 255, 0.2)' })
    if (!manual) {
      if (this.debounced) {
        this.debounced.cancel()
        this.debounced = null
      }
      this.debounced = debounce(() => {
        if (this.instance) {
          this.instance.close()
          this.instance = null
        }
      }, 1000)
      this.debounced && this.debounced()
    }
  },
  hide() {
    if (this.instance) {
      this.instance.close()
      this.instance = null
    }
  }
}
