import vue from '@vitejs/plugin-vue'
import vueJsx from '@vitejs/plugin-vue-jsx'
import { join } from 'path'
import { defineConfig, loadEnv } from 'vite'


function resolve(dir) {
  return join(__dirname, dir)
}
export default ({ mode }) => {
  const env = loadEnv(mode, process.cwd())

  return defineConfig({
    base: '',
    resolve: {
      alias: {
        '@': resolve('src')
      },
    },
    css: {
      preprocessorOptions: {
        scss: {
          additionalData: `
                  @use "sass:math";
                  @import "@/styles/settings/var.scss";
                  @import "@/styles/tools/index.scss";
              `,
        },
      },
    },
    plugins: [vue(), vueJsx()],
    server: {
      host: '0.0.0.0',
      port: 8080,
      proxy: {
        '/api': {
          changeOrigin: true,
          target: env.VITE_APP_DOMAIN,
        },
        '/k6_portal_api': {
          changeOrigin: true,
          target: env.VITE_APP_DOMAIN,
        },
        '/a3': {
          changeOrigin: true,
          target: env.VITE_APP_DOMAIN,
        },
      },
    },
  })
}

