import { createRouter, createWebHashHistory } from 'vue-router'
import { useK6Router } from '@k6/core-h5'

const routes = [
  {
    path: '/',
    redirect: '/home',

  },
  {
    path: '/k6-login/',
    name: 'login',
    meta: {
      index: 0
    },
    component: () => import('@/views/TemplateLogin.vue')
  },
  {
    path: '/home',
    name: 'home',
    meta: {
      index: 1
    },
    component: () => import('@/views/TemplateApp.vue')
  },
  {
    path: '/forms/:appId/:appName',
    props: true,
    name: 'forms',
    meta: {
      index: 2
    },
    component: () => import('@/views/TemplateForms.vue')
  },
  {
    path: '/table-data/:formId/:formName',
    props: true,
    name: 'tableData',
    meta: {
      index: 3
    },
    component: () => import('@/views/TemplateTable.vue')
  }
]

const router = createRouter({
  history: createWebHashHistory(),
  routes,
})
useK6Router(router)

export default router
