function projectInit(params) {
  // 设置tenant_id
  if (import.meta.env.VITE_APP_TENANT_ID) {
    localStorage.setItem('tenantId', import.meta.env.VITE_APP_TENANT_ID)
  }
  // 设置接口令牌
  if (import.meta.env.VITE_APP_TOKEN) {
    localStorage.setItem('token', import.meta.env.VITE_APP_TOKEN)
  }

  // 初始化完毕，设置 flag
  sessionStorage.setItem('projectInitialized', true)
}

if (import.meta.env.VITE_APP_TOKEN) {
  // 本地开发环境
  // 项目初始化时才使用环境变量设置应用 ID、token 等各种数据
  // 当数据失效时，使用页面中悬浮的 eruda 调试工具更换，不需要重启项目
  if (!sessionStorage.getItem('projectInitialized')) {
    projectInit()
  }
}

// 线上环境页面刷新清空缓存
if (!sessionStorage.getItem('projectInitialized')) {
  sessionStorage.clear()
}
