import { setup } from '@k6/plugin-axios'
import loading from './loading'
import { Notify } from 'vant'
import router from '../router/index'
const axios = setup({
  loading,
  cache: {
    maxAge: 5 * 1000 // 本地缓存 5 秒
  },
  throttle: {
    threshold: 5 * 1000 // 5秒
  },
  errorAction: (error) => {
    Notify({ type: 'danger', message: error.message });
  },
  authFailAction: (error) => {
    Notify({ type: 'danger', message: '登录失效' });
    router.push({
      name: 'login',
    })
    // logout 返回到登录页面逻辑
    console.log('%c::: 登录失效 ::: ', 'color: green; background: yellow; font-size: 30px');
    return Promise.reject(error)
  },
})

const { get, post } = axios


/**
 * 请求菜单列表
 * @param {*} appId
 * @returns
 */
export const getMenuByAppId = (appId) => {
  return get(`/api/auth/apps/${appId}/menus?equipmentType=1`)
}

// 通过menuID获取tabs
export const getTabsByMenuId = id => {
  return get(`/api/design/forms/${id}/tabs`)
}

// 获取所有应用
export const getApps = () => {
  return get(`/api/auth/navigate/apps/?equipmentType=1`)
}

// 获取应用信息
export const getAppById = id => {
  return get(`/api/design/apps/${id}`)
}

export const login = (data) => {
  return post(`/api/auth/login`, data, {
  })
}

// 根据token获取用户信息
export function getUserInfo() {
  return get("/api/auth/oauth/auth_details/current");

}
/**
 * 获取表单的设计信息
 * @param {*} formId
 * @returns
 */
export const getFormInfo = (formId) => {
  return get(`/api/design/forms/${formId}/formSimpleInfo`)
}