import DemoFormInput from './src/components/DemoFormInput/index.vue'
import DemoFormButton from './src/components/DemoFormButton/index.vue'

/**
 * 导出方式一和方式二导出组件都可以，原理都是resole了组件
 * 推荐使用方式一导出组件
 * 因为组件的name是必填，可以及时发现name没有设置的情况
 * 自定义页面开发比较特殊，映射的KEY必须是「K6CUSTOMPAGE」
 */
export default { 
  [DemoFormButton.name]: Promise.resolve(DemoFormButton), // 导出方式一
  [DemoFormInput.name]: Promise.resolve(DemoFormInput), // 导出方式一
  DemoTableColumn: import('./src/components/DemoTableColumn/index.vue'), // 导出方式二
  DemoTableButton: import('./src/components/DemoTableButton/index.vue'), // 导出方式二
  // 自定义页面 
  K6CUSTOMPAGE: import('./src/components/DemoCustomPage/index.vue') // 导出方式二
}
