module.exports = function () {
  const path = require('path')

  const resolve = (filePath) => {
    return path.resolve(__dirname, filePath)
  }

  // 手动配置，针对目录无规律
  // const entry = {
  //   'DemoFormInput': resolve('./src/components/DemoFormInput/index.vue'),
  // }

  // 批量生成 entry，目录有规律
  const entry = [
    "DemoFormInput",
    "DemoFormButton",
    "DemoCustomPage",
    // "DemoTableColumn",
    // "DemoTableButton"
  ].reduce((obj, name) => {
    obj[name] = resolve(`./src/components/${name}/index.vue`)
    return obj
  }, {})

  return entry
}
